define(['angular', 'app'], function(angular, app) {
	app.constant('NotificationsConstants', {
		'all-notifications': {
			summary: {
				enableSourceFilter: true,
				filter: {
					defaults: {
						type: 'FIT_HEART,STAFF'
					}
				}
			}
		},

		'fit-heart-notices': {
			summary: {
				filter: {
					defaults: {
						type:'FIT_HEART'
					}
				}
			}
		},

		'va-health-messages': {
			summary: {
				filter: {
					defaults: {
						type: 'STAFF'
					}
				}
			}
		},

		'notification' : {
			'scope' : {
				'optInOptions' : ['Yes', 'No'],
				'timeZoneOptions': [
					'(+00:00) WET (Western European Time)',
					'(+01:00) CET (Central European Time)',
					'(+02:00) EET (Eastern European Time)',
					'(+04:00) Europe/Moscow',
					'(+04:00) Asia/Dubai',
					'(+04:30) Asia/Kabul',
					'(+05:00) Asia/Aqtau',
					'(+05:00) Asia/Aqtobe',
					'(+05:45) Asia/Kathmandu',
					'(+06:00) Asia/Almaty',
					'(+06:30) Asia/Rangoon',
					'(+07:00) Asia/Bangkok',
					'(+07:00) Asia/Jakarta',
					'(+08:00) Asia/Singapore',
					'(+09:00) Asia/Jayapura',
					'(+09:00) Asia/Tokyo',
					'(+11:00) Asia/Sakhalin',
					'(+10:00) Australia/Sydney',
					'(+12:00) Asia/Anadyr',
					'(+12:00) Antarctica/McMurdo',
					'(+12:00) Pacific/Fiji',
					'(+13:00) Pacific/Enderbury',
					'(+14:00) Pacific/Kiritimati',
					'(-01:00) Atlantic/Cape_Verde',
					'(-01:00) America/Scoresbysund',
					'(-03:00) America/Argentina/San_Juan',
					'(-04:00) America/Argentina/San_Luis',
					'(-05:00) America/New_York (Eastern)',
					'(-06:00) America/Chicago (Central)',
					'(-07:00) America/Denver (Mountain)',
					'(-08:00) America/Los_Angeles (Pacific)',
					'(-09:00) America/Juneau',
					'(-10:00) Pacific/Honolulu',
					'(-11:00) Pacific/Midway',
					'(+00:00) Etc/GMT+12'
				]
			}
		}
	});
});